from django.db import models
from django.utils.translation import ugettext_lazy as _

from idm.core.constants.action import ACTION
from idm.core.models.baseaction import BaseAction
from idm.core.querysets.action import ActionManager
from idm.framework.fields import StrictForeignKey, NullJSONField as JSONField


class RoleNodeResponsibilityAction(BaseAction):
    system = StrictForeignKey(
        'core.System',
        verbose_name=_('Система'),
        null=True,
        blank=True,
        related_name='rolenoderesponsibilityactions',
        on_delete=models.CASCADE,
    )
    node_responsibility = StrictForeignKey(
        'core.NodeResponsibility',
        null=True, blank=True, default=None,
        verbose_name=_('Ответственный узла дерева ролей'),
        related_name='actions',
        on_delete=models.SET_NULL,
    )
    requester = StrictForeignKey(
        'users.User',
        verbose_name=_('От имени'),
        related_name='requestedrolenoderesponsibilityactions',
        null=True, default=None,
        on_delete=models.CASCADE,
    )
    role_node = StrictForeignKey(
        'core.RoleNode',
        null=True, blank=True, default=None,
        verbose_name=_('Узел дерева ролей'),
        related_name='rolenoderesponsibilityactions',
        on_delete=models.SET_NULL,
    )
    action = models.CharField(
        verbose_name=_('Действие'),
        choices=[(key, triple[0]) for key, triple in ACTION.ACTIONS.items()],
        max_length=50,
        db_index=True,
        null=True,
    )
    added = models.DateTimeField(
        verbose_name=_('дата'),
        auto_now_add=True,
        db_index=True,
    )
    data = JSONField(blank=True, null=True)
    parent = StrictForeignKey(
        'core.Action',
        null=True, blank=True, default=None,
        verbose_name=_('Родитель'),
        related_name='rolenoderesponsibilitychildren',
        on_delete=models.CASCADE,
    )

    objects = ActionManager()

    class Meta:
        verbose_name = _('Действие с ответственностью за узел')
        verbose_name_plural = _('Действия с ответственностью за узел')
