from django.db import models
from django.utils.translation import ugettext_lazy as _

from idm.core.constants.rolefield import FIELD_TYPE, FIELD_STATE
from idm.framework.fields import StrictForeignKey, NullJSONField as JSONField
from idm.framework.mixins import LocalizedModel

from .rolefield import RoleFieldFrontendApiMixin


class SystemRoleField(RoleFieldFrontendApiMixin, LocalizedModel, models.Model):
    slug = models.SlugField(max_length=255, default='', unique=True)
    name = models.CharField(_('Название'), max_length=255, default='', db_index=True, blank=True)
    name_en = models.CharField(_('Название (англ.)'), max_length=255, default='', db_index=True, blank=True)
    created_at = models.DateTimeField(_('Дата создания'), auto_now_add=True)
    updated_at = models.DateTimeField(_('Дата обновления'), auto_now=True)
    is_required = models.BooleanField(_('Обязательное поле'), default=False)
    type = models.CharField(_('Тип поля'), choices=FIELD_TYPE.TYPE_CHOICES, max_length=255,
                            db_index=True, default=FIELD_TYPE.CHARFIELD)
    options = JSONField(_('Настройки поля'), null=True, blank=True)
    state = models.CharField(_('Состояние поля'), choices=FIELD_STATE.STATE_CHOICES,
                             default=FIELD_STATE.CREATED, db_index=True, max_length=50)
    system = StrictForeignKey('core.System', related_name='systemrolefields', on_delete=models.CASCADE)
