from django.db import models

from idm.core.constants.system import IDM_SYSTEM_TREE
from idm.framework.fields import StrictForeignKey


class SystemRolePush(models.Model):
    system = StrictForeignKey('core.System', related_name='role_pushes', on_delete=models.CASCADE)
    user = StrictForeignKey('users.User', null=True, on_delete=models.CASCADE)
    group = StrictForeignKey('users.Group', null=True, on_delete=models.CASCADE)
    role_slug = models.SlugField(choices=IDM_SYSTEM_TREE.CHOICES)
