# coding: utf-8


from django import forms, http
from django.views.generic import FormView

from idm.utils.oebs_conflicts import generate_workflow


class UploadOEBSForm(forms.Form):
    file = forms.FileField()


class OebsConflictView(FormView):
    template_name = 'idm_admin/oebs_conflicts.html'
    form_class = UploadOEBSForm

    def get_context_data(self, **kwargs):
        context = super(OebsConflictView, self).get_context_data(**kwargs)
        context['title'] = 'OEBS Conflicts'
        return context

    def form_valid(self, form):
        context = self.get_context_data()
        context.update({
            'workflow': generate_workflow(form.cleaned_data['file']),
            'form': self.get_form()
        })
        return self.render_to_response(context)


upload_oebs_conflicts = OebsConflictView.as_view()
