# coding: utf-8


import weakref


class BasePlugin(object):
    """ Базовый класс для плагинов.
        Класс должен предоставлять "ручки" для получения
        названий ролей в конкретной системе.
    """

    def __init__(self, system):
        self.system = weakref.proxy(system)

    def get_info(self, *args, **kwargs):
        """Роли, запрошенные у системы"""
        raise NotImplementedError

    def get_all_roles(self, *args, **kwargs):
        raise NotImplementedError

    def get_roles(self, *args, **kwargs):
        raise NotImplementedError

    def get_memberships(self, *args, **kwargs):
        raise NotImplementedError

    def add_role(self, **kwargs):
        raise NotImplementedError

    def remove_role(self, **kwargs):
        raise NotImplementedError

    def add_group_membership(self, *args, **kwargs):
        raise NotImplementedError

    def remove_group_membership(self, *args, **kwargs):
        raise NotImplementedError
