# coding: utf-8


from django.utils.encoding import force_text
from six import python_2_unicode_compatible

from idm.framework.task import UnrecoverableError, DelayingError
from idm.utils.cleansing import hide_secret_params


@python_2_unicode_compatible
class BasePluginError(RuntimeError):
    def __init__(self, code, message, data=None, answer=None):
        self.code = code
        self.message = force_text(message)
        hide_secret_params(data)
        self.data = data
        self.answer = answer

    def __str__(self):
        return '{cls}: code={code}, message="{message}", data={data}, answer="{answer}"'.format(
            cls=self.__class__.__name__, code=self.code, message=self.message, data=self.data, answer=self.answer
        )


class PluginError(BasePluginError, DelayingError):
    """Ошибка в плагине, в случае которой нужно поретраиться"""


class PluginFatalError(BasePluginError, UnrecoverableError):
    """Ошибка в плагине, в случае которой стоит упасть, так как ретрай бесполезен"""
