# coding: utf-8


import logging

from idm.core.plugins.generic import Plugin as NewPlugin, PluginField
from idm.utils.check_switch import check_switch
from idm.core.exceptions import PushDisabled

log = logging.getLogger(__name__)


class Plugin(NewPlugin):
    ROLE_PUSH_SCHEMA = [
        PluginField(key='role', src_key='role_data', json=True),
        PluginField(key='login', src_key='username', optional=True),
        PluginField(key='group', src_key='group_id', optional=True),
        PluginField(key='uid', optional=True),
    ]
    ROLE_PUSH_SCHEMA_ADD = [
        PluginField(key='fields', src_key='fields_data', json=True),
    ]
    ROLE_PUSH_SCHEMA_REMOVE = [
        PluginField(key='data', src_key='system_specific', json=True),
    ]

    @check_switch('disable_pushes_all', 'disable_pushes_add_roles', raise_=PushDisabled())
    def add_role(self, **kwargs):
        push_data = self.make_push_data(self.ROLE_PUSH_SCHEMA + self.ROLE_PUSH_SCHEMA_ADD, kwargs)
        self.log_push(push_data)
        return self._post_data('add-role', push_data)

    @check_switch('disable_pushes_all', 'disable_pushes_remove_roles', raise_=PushDisabled())
    def remove_role(self, **kwargs):
        push_data = self.make_push_data(self.ROLE_PUSH_SCHEMA + self.ROLE_PUSH_SCHEMA_REMOVE, kwargs, for_remove=True)
        self.log_push(push_data)
        return self._post_data('remove-role', push_data)
