# coding: utf-8

import logging

from idm.core.plugins.generic import Plugin as GenericPlugin, PluginField

log = logging.getLogger(__name__)


class Plugin(GenericPlugin):
    ROLE_PUSH_SCHEMA = [
        PluginField(key='role', src_key='role_data', json=True),
        PluginField(key='fields', src_key='fields_data', json=True),
        PluginField(key='path'),
        PluginField(key='with_inheritance'),
        PluginField(key='with_robots'),
        PluginField(key='with_external'),
        PluginField(key='login', src_key='username', optional=True),
        PluginField(key='group', src_key='group_id', optional=True),
        PluginField(key='uid', optional=True),
        PluginField(key='subject_type', optional=True)
    ]
