import weakref


class BaseNodesPlugin:
    """
        Базовый класс для плагинов получения узлов.
        Класс должен предоставлять "ручки" для получения
        названий ролей в конкретной системе.
    """

    def __init__(self, system):
        self.system = weakref.proxy(system)

    def get_info(self, *args, **kwargs):
        raise NotImplementedError
