import yaml
import logging

from idm.core import exceptions
from idm.core.plugins.plugins_mixin import RequestMixin
from idm.core.plugins.nodes.base import BaseNodesPlugin
from django.utils.translation import ugettext as _


log = logging.getLogger(__name__)


class NodesPlugin(BaseNodesPlugin, RequestMixin):
    def get_info(self, *args, **kwargs):
        if not self.system.roles_tree_url:
            raise exceptions.URLNotDefined(_('Не установлена ссылка на дерево в параметрах системы'))

        def _parse_yaml_response(response):
            return yaml.safe_load(response.content)

        try:
            roles = self._send_data(
                self.system.roles_tree_url,
                method='GET',
                timeout=60,
                parse_response=_parse_yaml_response,
            )
        except Exception:
            log.warning(f'During get_info from {self.system.slug} with params {kwargs}', exc_info=True)
            raise

        return roles
