# coding: utf-8
import json

from django.conf import settings
from django.core.handlers.wsgi import WSGIRequest
from django_tools_log_context.provider.base import BaseProvider

import logging

log = logging.getLogger(__name__)

WRITE_METHODS = ('POST', 'PUT', 'DELETE', 'UPDATE')


class Provider(BaseProvider):
    required_kwargs = ['request']

    # FIXME DEPRECATED (use idm.core.providers.batch_request.Provider.batch)
    def batch_request_uid(self, request):
        ctx = {}
        if request.META.get(settings.IDM_BATCH_REQUEST_HEADER) and request.method in WRITE_METHODS:
            ctx['batch_request_uid'] = request.META.get(settings.IDM_BATCH_REQUEST_HEADER)
        return ctx

    @staticmethod
    def _extract_body(request: WSGIRequest):
        body = request.body
        if not body:
            return '<EMPTY>'

        try:
            body = body.decode()
        except UnicodeDecodeError:
            pass

        try:
            if len(request.body) > settings.BATCH_REQUEST_BODY_LOG_MAX_SIZE:
                strip_size = settings.BATCH_REQUEST_BODY_LOG_MAX_SIZE // 2 - 4
                body = '<{prefix}....{suffix}>'.format(prefix=body[:strip_size], suffix=body[-strip_size:])
            else:
                body = json.loads(body)
            return body
        except ValueError:
            log.exception(
                'Invalid json in batch subrequest %s body %s to %s', request.method, request.body, request.path
            )
            return '<PARSE_ERROR>'

    @classmethod
    def _subrequests_count(cls, request: WSGIRequest):
        batch_body = cls._extract_body(request)
        if not isinstance(batch_body, (dict, list)):
            return None
        elif isinstance(batch_body, dict):
            batch_body = batch_body.get('requests', [])
        if isinstance(batch_body, list):
            return len(batch_body)

    def batch(self, request: WSGIRequest):
        batch_context = {}
        if request.META.get('IS_BATCH_SUBREQUEST') and request.method in WRITE_METHODS:
            batch_context['body'] = self._extract_body(request)
        if request.META.get(settings.IDM_BATCH_REQUEST_HEADER) and request.method in WRITE_METHODS:
            batch_context['id'] = request.META.get(settings.IDM_BATCH_REQUEST_HEADER)
            batch_context['total_subrequests'] = self._subrequests_count(request)

        return batch_context
