# coding: utf-8
import json

from django.conf import settings
from django_tools_log_context.provider.base import BaseProvider

import logging

log = logging.getLogger(__name__)


class Provider(BaseProvider):
    required_kwargs = ['request']

    # FIXME DEPRECATED (use idm.core.providers.batch_request.Provider.batch)
    def post_body(self, request):
        ctx = {}
        if request.META.get('IS_BATCH_SUBREQUEST') and request.method in ('POST', 'PUT', 'DELETE', 'UPDATE'):
            if request.body:
                try:
                    body = request.body
                    if len(request.body) > settings.BATCH_REQUEST_BODY_LOG_MAX_SIZE:
                        strip_size = settings.BATCH_REQUEST_BODY_LOG_MAX_SIZE // 2 - 2
                        body = '{prefix}....{suffix}'.format(prefix=body[:strip_size], suffix=body[-strip_size:])
                    else:
                        body = json.loads(body)
                    ctx['body'] = body
                except ValueError:
                    log.exception(
                        'Invalid json in batch subrequest %s body %s to %s',
                        request.method,
                        request.body,
                        request.path,
                    )
                    ctx['body'] = '<PARSE_ERROR>'
            else:
                ctx['body'] = '<EMPTY>'
        return ctx
