# coding: utf-8
from django.core.handlers.wsgi import WSGIRequest
from django_tools_log_context.provider.base import BaseProvider


class Provider(BaseProvider):
    required_kwargs = ['request']

    def system_request_id(self, request: WSGIRequest):
        return request.META.get('HTTP_X_SYSTEM_REQUEST_ID')

    def x_request_id(self, request: WSGIRequest):
        return request.META.get('HTTP_X_REQUEST_ID')
