# coding: utf-8


from django.db.models import Q
from django.db import models

from idm.core.querysets.base import BasePermittedRolesQuerySet
from idm.framework.requester import requesterify


class ActionQuerySet(BasePermittedRolesQuerySet):
    prefix = 'role__'

    def basic_role_related(self):
        return self.select_related('role__user', 'role__group', 'role__system', 'role__node')

    def permitted_query(self, requester, base=None, system=None, **kwargs):
        requester = requesterify(requester).impersonated

        # Разрешаем пользователю смотреть все экшены, которые к нему как-то
        # имеют отношение, а не только привязанные к ролям
        base = (base or Q()) | (
            Q(requester=requester) |
            Q(impersonator=requester) |
            Q(user=requester) |
            Q(system__in=requester.get_systems_with_responsibility())
        )

        return super(ActionQuerySet, self).permitted_query(requester, base, system)


class ActionManager(models.Manager.from_queryset(ActionQuerySet)):
    """
    Менеджер для работы с моделью действия, учитывающий разрешения
    """
