# coding: utf-8

from django.db import models


class InternalRoleQuerySet(models.QuerySet):
    def global_(self):
        return self.filter(node=None)

    def local(self):
        return self.filter(node__isnull=False)

    def root(self):
        return self.filter(node__level=0)


class InternalRoleManager(models.Manager.from_queryset(InternalRoleQuerySet)):
    """Менеджер внутренних ролей"""
