# coding: utf-8


from django.db import models
from guardian.managers import UserObjectPermissionManager


class InternalUserObjectPermissionQuerySet(models.QuerySet):
    def global_(self):
        return self.filter(content_object__node=None)

    def local(self):
        return self.filter(content_object__node__isnull=False)


class InternalUserObjectPermissionManager(models.Manager.from_queryset(InternalUserObjectPermissionQuerySet),
                                          UserObjectPermissionManager):
    """Менеджер guardian-пермишенов"""
