# coding: utf-8


from django.db import models


class NetworkMacroQuerySet(models.QuerySet):
    def active(self):
        return self.filter(is_active=True)

    def inactive(self):
        return self.filter(is_active=False)

    def lock_by_select(self):
        return list(self.select_for_update().values_list('pk', flat=True))


class NetworkMacroManager(models.Manager.from_queryset(NetworkMacroQuerySet)):
    """
    Менеджер для работы с моделью сетевого макроса
    """
