# coding: utf-8


from django.db import models

from idm.utils.diff import get_diff


class WorkflowQuerySet(models.QuerySet):
    def approved(self):
        return self.filter(state='approved')


class WorkflowManager(models.Manager.from_queryset(WorkflowQuerySet)):
    def get_diffs(self, old_workflow, new_workflow, highlight=True, full=False):
        assert new_workflow is not None, "New workflow must be provided"
        diffs = []
        for attname in ('workflow', 'group_workflow'):
            old_text = getattr(old_workflow, attname) if old_workflow else ''
            new_text = getattr(new_workflow, attname)
            diff = get_diff(old_text, new_text, full=full, highlight=highlight)
            diffs.append(diff)

        return diffs
