# coding: utf-8

import abc

from idm.core.models import Role


class BaseValidator(object):
    __metaclass__ = abc.ABCMeta

    def __init__(self, role: Role):
        self.role = role

    @abc.abstractmethod
    def check(self, passport_login_id, **kwargs):
        pass
