DROP FUNCTION IF EXISTS count_estimate( QUERY TEXT );
CREATE FUNCTION count_estimate(query TEXT)
  RETURNS INTEGER AS
$func$
DECLARE
  rec  RECORD;
  ROWS INTEGER;
BEGIN
  FOR rec IN EXECUTE 'EXPLAIN ' || query LOOP
    ROWS := SUBSTRING(rec."QUERY PLAN" FROM ' rows=([[:digit:]]+)');
    EXIT WHEN ROWS IS NOT NULL;
  END LOOP;

  RETURN ROWS;
END
$func$ LANGUAGE plpgsql;
