-- action
CREATE OR REPLACE FUNCTION fill_action_id()
  RETURNS trigger AS '
BEGIN
  if NEW.new_id ISNULL
  then
    if NEW.id > 0
    then UPDATE upravlyator_action
    SET new_id = NEW.id
    WHERE id = NEW.id;
    end if;
    if NEW.id < 0
    then UPDATE upravlyator_action
    SET new_id = NEW.id + 2 ^ 32
    WHERE id = NEW.id;
    end if;
  end if;
  if NEW.new_parent_id ISNULL AND NEW.parent_id IS NOT NULL
  then
    if NEW.parent_id > 0
    then UPDATE upravlyator_action
    SET new_parent_id = NEW.parent_id
    WHERE id = NEW.id;
    end if;
    if NEW.parent_id < 0
    then UPDATE upravlyator_action
    SET new_parent_id = NEW.parent_id + 2 ^ 32
    WHERE id = NEW.id;
    end if;
  end if;
  return NEW;
END;
'
LANGUAGE plpgsql;

CREATE TRIGGER fill_action_id
  AFTER INSERT
  ON upravlyator_action
  FOR EACH ROW
  WHEN ((NEW.id IS NOT NULL AND NEW.new_id IS NULL) OR
        (NEW.parent_id IS NOT NULL AND NEW.new_parent_id IS NULL)) EXECUTE PROCEDURE fill_action_id();


-- upravlyator_inconsistency
CREATE OR REPLACE FUNCTION fill_inc_sync_key_id()
  RETURNS trigger AS '
BEGIN
  if NEW.new_sync_key_id IS NULL AND NEW.sync_key_id IS NOT NULL
  then
    if NEW.sync_key_id > 0
    then UPDATE upravlyator_inconsistency
    SET new_sync_key_id = NEW.sync_key_id
    WHERE id = NEW.id;
    end if;
    if NEW.sync_key_id < 0
    then UPDATE upravlyator_inconsistency
    SET new_sync_key_id = NEW.sync_key_id + 2 ^ 32
    WHERE id = NEW.id;
    end if;
  end if;
  return NEW;
END;
'
LANGUAGE plpgsql;

CREATE TRIGGER fill_inc_sync_key_id
  AFTER INSERT
  ON upravlyator_inconsistency
  FOR EACH ROW
  WHEN ((NEW.sync_key_id IS NOT NULL AND NEW.new_sync_key_id IS NULL)) EXECUTE PROCEDURE fill_inc_sync_key_id();


-- groupmembership_inconsistency
CREATE OR REPLACE FUNCTION fill_gm_inc_sync_key_id()
  RETURNS trigger AS '
BEGIN
  if NEW.new_sync_key_id IS NULL AND NEW.sync_key_id IS NOT NULL
  then
    if NEW.sync_key_id > 0
    then UPDATE groupmembership_inconsistency
    SET new_sync_key_id = NEW.sync_key_id
    WHERE id = NEW.id;
    end if;
    if NEW.sync_key_id < 0
    then UPDATE groupmembership_inconsistency
    SET new_sync_key_id = NEW.sync_key_id + 2 ^ 32
    WHERE id = NEW.id;
    end if;
  end if;
  return NEW;
END;
'
LANGUAGE plpgsql;

CREATE TRIGGER fill_gm_inc_sync_key_id
  AFTER INSERT
  ON groupmembership_inconsistency
  FOR EACH ROW
  WHEN ((NEW.sync_key_id IS NOT NULL AND NEW.new_sync_key_id IS NULL)) EXECUTE PROCEDURE fill_gm_inc_sync_key_id();
