# -*- coding: utf-8 -*-


from idm.core.tasks.everysync import EverySync
from idm.core.tasks.intrasearch_push import PushItemChange
from idm.core.tasks.passport import SubscribePassportLogin, UnsubscribePassportLogin
from idm.core.tasks.roles import (
    RoleAdded,
    RoleRemoved,
    DepriveInconsistentRole,
    DepriveInconsistentRoleAndRequestNew,
    DepriveRoleRefs,
    DepriveRolesWhenDetachingResource,
    RequestRoleRefs,
    RerunWorkflow,
    RequestNewSystemResponsibles,
    PokeAwaitingRoles,
)
from idm.core.tasks.roles_export import ExportRoles
from idm.core.tasks.dismissing import DisableAccount, DismissUser
from idm.core.tasks.nodes import (
    RoleNodeRemoved,
    RoleNodeRolesDeprived,
    CreateRoleFieldIndex,
    DropRoleFieldIndex,
)
from idm.core.tasks.group_memberships import (
    ActivateGroupMembershipSystemRelations,
    DepriveGroupMembershipSystemRelations,
    UpdateGroupMembershipSystemRelations,
    SyncGroupMembershipSystemRelations,
    CheckGroupMembershipPassportLogin,
)
from idm.core.tasks.systems import SystemShutdown

__all__ = [
    b'EverySync',
    b'RoleAdded', b'RoleRemoved', b'DepriveInconsistentRole', b'DepriveInconsistentRoleAndRequestNew',
    b'RequestRoleRefs', b'DepriveRoleRefs', b'RequestNewSystemResponsibles', b'DepriveRolesWhenDetachingResource',
    b'RerunWorkflow',
    b'SubscribePassportLogin', b'UnsubscribePassportLogin',
    b'DisableAccount', b'DismissUser', b'PushItemChange',
    b'RoleNodeRemoved', b'RoleNodeRolesDeprived',
    b'CreateRoleFieldIndex', b'DropRoleFieldIndex',
    b'ActivateGroupMembershipSystemRelations', b'DepriveGroupMembershipSystemRelations',
    b'UpdateGroupMembershipSystemRelations', b'SyncGroupMembershipSystemRelations',
    b'CheckGroupMembershipPassportLogin',
    b'PokeAwaitingRoles',
    b'SystemShutdown',
    'ExportRoles',
]
