# -*- coding: utf-8 -*-


import time

from idm.celery_app import app
from idm.framework.task import BaseTask, UnrecoverableError


class ErrorTask(BaseTask):
    """Класс исключительно для тестирования логирования в Celery.
    """
    monitor_success = False  # странная ненужная таска

    def init(self):
        self.log.info('just a message from the task')
        raise UnrecoverableError('error from the task')


class PerformanceTask(BaseTask):
    """Таск для измерения задержки между постановкой задачи в очередь и ее исполнением.
    """
    monitor_success = False  # странная ненужная таска

    def init(self, task_num, start_time, **kwargs):
        cur_time = time.time()
        self.log.debug('task_id: %s, celery-latency: %.2f', task_num, cur_time - start_time)


ErrorTask = app.register_task(ErrorTask())
PerformanceTask = app.register_task(PerformanceTask())
