# coding: utf-8

import re
import subprocess
import tempfile

from django.core.exceptions import ValidationError
from django.utils.encoding import force_bytes, force_text
from django.utils.translation import ugettext_lazy as _


def sudoers_entry(value):
    with tempfile.NamedTemporaryFile() as f:
        f.write(b"login %s\n" % force_bytes(value))
        f.flush()

        try:
            result = subprocess.check_output(('/usr/sbin/visudo', '-cf', f.name), stderr=subprocess.STDOUT)

            if b'Warning' in result:
                warning = re.sub('{}:\d+ '.format(re.escape(f.name)), '', result.decode('utf-8').split('\n')[0])
                raise ValidationError(_('Предупреждение в правиле sudoers') + ': ' + warning)

        except subprocess.CalledProcessError as e:
            raise ValidationError(_('Ошибка в правиле sudoers') + ': ' + force_text(e.output).split('\n')[0])
