# coding: utf-8


from idm.api.frontend import fields
from idm.api.frontend.forms import BaseForm


class WorkflowForm(BaseForm):
    warnings = fields.IterableField(subfield_class=fields.WarningField, required=False, label='warnings')
    warning = fields.WarningField(required=False, label='warning')

    def clean(self):
        cleaned_data = super(WorkflowForm, self).clean()

        warning = cleaned_data.pop('warning', None)
        warnings = [item for item in cleaned_data.pop('warnings', []) if item is not None]

        if warning is not None:
            warnings.append(warning)

        cleaned_data['warnings'] = warnings
