from idm.core.workflow.plain.group import GroupWrapper
from idm.core.workflow.plain.node import NodeWrapper
from idm.core.workflow.plain.system import SystemWrapper
from idm.core.workflow.plain.user import UserWrapper
from idm.core.conflicts import find_conflicts


class ConflictWrapper:
    class WRAPPERS:
        NODE = NodeWrapper
        USER = UserWrapper
        GROUP = GroupWrapper
        SYSTEM = SystemWrapper
        ROLE = lambda x: x

    def __init__(self, requested_path, conflicting_path,
                 conflicting_system, email, subj, node):
        self.requested_path = requested_path
        self.conflicting_path = conflicting_path
        self.conflicting_system = conflicting_system
        self.email = email
        self.subj = subj
        self.node = node

    @classmethod
    def wrap(cls, conflict):
        if conflict.subj.is_user:
            subj = cls.WRAPPERS.USER(conflict.subj.user)
        else:
            subj = cls.WRAPPERS.GROUP(conflict.subj.group)
        return cls(
            requested_path=conflict.requested_path,
            conflicting_path=conflict.conflicting_path,
            conflicting_system=cls.WRAPPERS.SYSTEM(conflict.conflicting_system),
            email=conflict.email,
            node=cls.WRAPPERS.NODE(conflict.node),
            subj=subj)

    @classmethod
    def find_conflicts_wrapper(cls, node_wrapper, subj_wrapper, rules):
        from idm.core.workflow.common.subject import subjectify

        conflicts = find_conflicts(
            node=node_wrapper.object,
            subj=subjectify(getattr(subj_wrapper, subj_wrapper.object_attribute_name)),
            conflict_rules=rules)
        return {k: [(cls.WRAPPERS.ROLE(role), cls.wrap(conflict))
                    for role, conflict in conflicts_set]
                for k, conflicts_set in conflicts.items()}
