# coding: utf-8


from idm.core.workflow.exceptions import NodeHasNoParentError
from idm.core.workflow.plain.mixins import TreeMixin
from idm.framework.mixins import Representable


def nodify(thing):
    from idm.core.models import RoleNode
    if isinstance(thing, NodeWrapper):
        result = thing
    elif isinstance(thing, RoleNode):
        result = NodeWrapper(thing)
    else:
        raise ValueError('Cannot nodify')
    return result


class NodeWrapper(Representable, TreeMixin):
    halt = False
    object_attribute_name = 'node'
    no_parent_exception = NodeHasNoParentError

    def __init__(self, node):
        self.node = node

    def __str__(self):
        return self.object.get_name()

    def __getattr__(self, name):
        return getattr(self.object, name)

    def __eq__(self, other):
        return self.node == other.node

    def get_aliases(self, type=None):
        return list(self.object.get_aliases(type=type))

    def get_responsibilities(self):
        return list(self.object.get_responsibilities().select_related('user'))

    def get_owners(self, owning_slug, look_up=False, collect=False, groups=False, include_self=True):
        """Получить владельцев активных ролей, которые выданы на узел со слагом owning_slug,
        являющийся сестринским для текущего. Если look_up=True, то, если владельцев не нашлось,
        рекурсивно повторяем процедуру для родительского узла, до тех пор, пока владельцы не будут найдены.
        Если collect=True, то повторяем процедуру, даже если владельцы нашлись, таким образом собирая в единое множество
        владельцев текущего узла и всех его предков.
        """

        from idm.core.models import RoleNode
        result = RoleNode.objects.get_owners(
            node=self.object,
            owning_slug=owning_slug,
            look_up=look_up,
            collect=collect,
            groups=groups,
            include_self=include_self,
        )
        return result
