# coding: utf-8

from __future__ import unicode_literals

import json
import struct
import time

from django.utils.encoding import force_bytes
try:
    from idm.core.workflow.exceptions import WorkflowContainerTimeoutError
    from django.conf import settings
    RESPONSE_TIMEOUT = settings.IDM_WORKFLOW_SOCKET_TIMEOUT
except ImportError:
    from workflow_exceptions import WorkflowContainerTimeoutError
    RESPONSE_TIMEOUT = None


class Connection(object):
    def __init__(self, connection):
        self.connection = connection

    def connect(self, socket_path):
        self.connection.connect(socket_path)

    def send_data(self, response_code, data):
        encoded_data = force_bytes(json.dumps(data))
        header = struct.pack('<LL', response_code, len(encoded_data))
        self.connection.sendall(header+encoded_data)

    def _recvall(self, response_length):
        # Не очень эффективно в плане постоянного копирования памяти, но тут сойдёт
        data = b''
        to_get = response_length
        start = time.time()
        while to_get > 0:
            new_data = self.connection.recv(to_get)
            data += new_data
            to_get -= len(new_data)
            if RESPONSE_TIMEOUT and time.time() - start > RESPONSE_TIMEOUT:
                raise WorkflowContainerTimeoutError('Response timeout exceeded')
        return data

    def get_data(self):
        response_length_data = self._recvall(8)
        response_code, response_length = struct.unpack('<LL', response_length_data)
        raw_response_data = self._recvall(response_length)
        response_data = raw_response_data.decode()
        response = json.loads(response_data)
        return response_code, response

    def close(self):
        self.connection.close()
        self.connection = None
