from idm.core.workflow.plain.conflict import ConflictWrapper as PlainConflictWrapper
from idm.core.workflow.sandbox.manager.group import GroupWrapper
from idm.core.workflow.sandbox.manager.node import NodeWrapper
from idm.core.workflow.sandbox.manager.system import SystemWrapper
from idm.core.workflow.sandbox.manager.user import UserWrapper
from idm.core.workflow.sandbox.serializable import Serializable, serialize, deserialize
from idm.core.workflow.sandbox.manager.role import RoleWrapper
from idm.core.workflow.sandbox.manager.sanboxed import SandboxedMixin


class ConflictWrapper(SandboxedMixin, Serializable, PlainConflictWrapper):
    ALLOWED_METHODS = []
    ALLOWED_PROPERTIES = []
    INITIAL_PROPERTIES = []

    class WRAPPERS:
        NODE = NodeWrapper
        USER = UserWrapper
        GROUP = GroupWrapper
        SYSTEM = SystemWrapper
        ROLE = RoleWrapper

    def _as_dict(self):
        return {
            'subj': serialize(self.subj),
            'node': serialize(self.node),
            'conflicting_system': serialize(self.conflicting_system),
            'requested_path': self.requested_path,
            'conflicting_path': self.conflicting_path,
            'email': self.email,
        }

    @classmethod
    def from_dict(cls, data, context=None):
        system = deserialize(data.pop('conflicting_system'), context=context)
        node = deserialize(data.pop('node'), context=context)
        subj = deserialize(data.pop('subj'), context=context)
        return cls(
            conflicting_system=system,
            node=node,
            subj=subj,
            **data)

    def __eq__(self, other):
        attrs = ['requested_path', 'conflicting_path', 'conflicting_system', 'email', 'subj', 'node']
        return all(getattr(self, attr) == getattr(other, attr) for attr in attrs)
