# coding: utf-8

from idm.core.workflow.sandbox.manager.group import GroupWrapper
from idm.core.workflow.sandbox.manager.node import NodeWrapper
from idm.core.workflow.sandbox.manager.sanboxed import SandboxedMixin
from idm.core.workflow.sandbox.manager.system import SystemWrapper
from idm.core.workflow.sandbox.manager.user import UserWrapper
from idm.core.workflow.sandbox.serializable import Serializable


class RoleWrapper(SandboxedMixin, Serializable):
    ALLOWED_METHODS = []
    ALLOWED_PROPERTIES = ['system', 'node', 'user', 'group']
    INITIAL_PROPERTIES = ['system', 'node']

    def __init__(self, role, context=None):
        self.role = role
        self.context = context

    @classmethod
    def from_dict(cls, data, context=None):
        from idm.core.models import Role
        role_id = data['id']
        role = Role.objects.get(id=role_id)
        return cls(role, context=context)

    def _as_dict(self):
        return {
            'id': self.role.id,
        }

    @property
    def system(self):
        return SystemWrapper(self.role.system)

    @property
    def node(self):
        return NodeWrapper(self.role.node)

    @property
    def group(self):
        if self.role.group_id is None:
            return None

        return GroupWrapper(self.role.group)

    @property
    def user(self):
        if self.role.user_id is None:
            return None

        return UserWrapper(self.role.user)

    def get_absolute_url(self):
        return self.role.get_absolute_url()

    def email_humanize(self, lang=None, format='full'):
        return self.role.email_humanize(lang=lang, format=format)
