# coding: utf-8


from django.conf import settings
from django_pgaas.backend.base import DatabaseWrapper as BaseDatabaseWrapper
from zero_downtime_migrations.backend.schema import DatabaseSchemaEditor

from idm.framework.backend.cursor import BetterCursorDebugWrapper, RetryCursorWrapper, RetryCursorDebugWrapper
from idm.framework.backend.operations import DatabaseOperations


class DatabaseWrapper(BaseDatabaseWrapper):
    SchemaEditorClass = DatabaseSchemaEditor
    retry_connect_count = 10
    retry_timeout = 1

    def __init__(self, *args, **kwargs):
        super(DatabaseWrapper, self).__init__(*args, **kwargs)
        self.force_debug_cursor = settings.IDM_SQL_DEBUG
        self.ops = DatabaseOperations(self)

    def make_debug_cursor(self, cursor):
        if settings.IDM_SQL_DEBUG:
            wrapper = BetterCursorDebugWrapper(cursor, self)
        else:
            wrapper = RetryCursorDebugWrapper(cursor, self)
        return wrapper

    def make_cursor(self, cursor):
        return RetryCursorWrapper(cursor, self)
