# coding: utf-8


from django.db.migrations.operations.base import Operation


class TransactionOperation(Operation):
    reduces_to_sql = False
    help = 'Transaction operation'

    def deconstruct(self):
        return (
            self.__class__.__name__,
            [],
            {}
        )

    @property
    def reversible(self):
        return False

    def state_forwards(self, app_label, state):
        # RunPython objects have no state effect. To add some, combine this
        # with SeparateDatabaseAndState.
        pass

    def database_forwards(self, app_label, schema_editor, from_state, to_state):
        raise NotImplementedError("You cannot reverse this operation")

    def database_backwards(self, app_label, schema_editor, from_state, to_state):
        raise NotImplementedError("You cannot reverse this operation")

    def describe(self):
        return self.help


class Commit(TransactionOperation):
    help = """Commits current transaction"""

    def database_forwards(self, app_label, schema_editor, from_state, to_state):
        schema_editor.atomic.__exit__(None, None, None)


class Begin(TransactionOperation):
    help = """Begins new transaction"""

    def database_forwards(self, app_label, schema_editor, from_state, to_state):
        schema_editor.atomic.__enter__()
