# coding: utf-8
import logging
from metrics_framework.decorators import metric

from idm.core.models import System

log = logging.getLogger(__name__)


@metric('abc_refs')
def get_abc_wrong_refs():
    head_roles = ('1', '52', '830')
    abc = System.objects.get(slug='abc')
    roles = abc.roles.active().filter(node__slug__in=head_roles)
    qs = roles.values_list('pk', 'node__parent__parent__parent__value_path', 'ref_roles')
    wrong_pks = []
    for pk, path, refs in qs:
        if len(refs) != 1:
            wrong_pks.append(pk)
        else:
            scope = refs[0].get('role_fields', {}).get('scope')
            if path != scope:
                wrong_pks.append(pk)

    joined = ','.join(map(str, sorted(wrong_pks)))

    log.info('Wrong abc refs: %s', joined)
    result = [{
        'slug': 'abc_wrong_refs',
        'value': len(wrong_pks)
    }]
    return result
