# coding: utf-8



from metrics_framework.decorators import metric
from django.utils import timezone

from idm.core.constants.rolenode import ROLENODE_STATE
from idm.core.models import RoleNode


@metric('depriving_nodes_number')
def depriving_nodes_number():
    return [{
        'slug': 'depriving_nodes_number',
        'value': RoleNode.objects.filter(
            depriving_at__lt=timezone.now()-timezone.timedelta(hours=1),
            state=ROLENODE_STATE.DEPRIVING,
        ).count(),
    }]
