# coding: utf-8



import constance
from django.db.models import Count, F
from django.utils import timezone
from metrics_framework.decorators import metric

from idm.core.constants.approverequest import APPROVEREQUEST_DECISION
from idm.core.models import ApproveRequest, System


@metric('ignored_requests_count_1')
def count_ignored_requests_count_1():
    return count_ignored_requests(0, 90)


@metric('ignored_requests_count_2')
def count_ignored_requests_count_2():
    return count_ignored_requests(90, 180)


@metric('ignored_requests_count_3')
def count_ignored_requests_count_3():
    return count_ignored_requests(180, 270)


def count_ignored_requests(start, end):
    all_slugs = set(System.objects.order_by('id').values_list('slug', flat=True)[start:end])
    ignored_requests = list(
        ApproveRequest.objects
        .filter(
            decision=APPROVEREQUEST_DECISION.IGNORE,
            updated__gte=timezone.now() - timezone.timedelta(hours=constance.config.IGNORED_REQUESTS_METRIC_PERIOD)
        )
        .annotate(slug=F('approve__role_request__role__system__slug'))
        .values('slug')
        .annotate(value=Count('slug'))
        .order_by('id')[start:end]
    )
    used_slugs = {x['slug'] for x in ignored_requests}
    not_used_slugs = all_slugs - used_slugs
    for slug in not_used_slugs:
        ignored_requests.append({'slug': slug, 'value': 0})

    for x in ignored_requests:
        x['slug'] = x['slug'].replace('-', '_').replace('.', '_')  # нельзя использовать "-" и "." в статфейсе
        # Нельзя начинать имя с цифры
        if x['slug'][0].isdigit():
            x['slug'] = 'a' + x['slug']

    return ignored_requests
