import yenv

from idm.metrics.management.base_api_response_percentile import MetricBaseCommand, MINUTE_LOG, DAY_LOG


class Command(MetricBaseCommand):
    help = """Считает и загружает в статфейс статистику по времени ответа ручек"""

    SYNTAX_VERSION = 1

    LOG_PATH = {
        MINUTE_LOG: 'home/logfeller/logs/qloud-router-log/stream/5min/',
        DAY_LOG: 'home/logfeller/logs/qloud-router-log/1d/',
    }

    REPORT_PATH = {
        MINUTE_LOG: 'ExtData/idm/api/idm_api_response_time_day_5min/minutely',
        DAY_LOG: 'ExtData/idm/api/idm_api_response_time_day/daily',
    }

    PERIOD_LENGTH = {
        MINUTE_LOG: 5,
        DAY_LOG: 1440,
    }

    YQL_QUERY = r"""
        -- idm_api_responce_percentile
        USE hahn;
        
        $path_match = Re2::Match("^/api/[\\w,\\-]+/[\\w,\\-]+(/\\?.*|/)$");
        $capture = Pire::Capture("(/api/[\\w,\\-,\\d]+/[\\w,\\-,\\d]+/).*");
        $details_path_match = Re2::Match("^/api/(v[\\d]+|b2b|frontend)/((roles|approverequests)/\\d+/?$|rolenodes/([\\d,\\w,\\-]+/)+)");
        $details_capture = Pire::Capture("^(/api/(v[\\d]+|b2b|frontend)/(roles|approverequests|rolenodes)/)");
        
        UPSERT INTO {stat_cluster}.`{report_path}`
            SELECT  '{table_name}' as fielddate,
                    http_method,
                    request_path,
                    PERCENTILE(execution_time, 0.90) as percentile_90,
                    PERCENTILE(execution_time, 0.95) as percentile_95,
                    PERCENTILE(execution_time, 0.99) as percentile_99,
                    COUNT(*) as requests_count,
                    COUNT_IF(status < "300") AS ok_responses_count,
                    CAST(COUNT(*) as Double) / {period_length} AS rpm
               FROM (
                    -- COALESCE для конверитирования String? -> String 
                    SELECT COALESCE($capture(request), "") as request_path,
                           IF(status < "300", CAST(nginx_request_time as Double))  as execution_time,
                           COALESCE(nginx_request_method, "") as http_method,
                           status
                      FROM `{log_path}{table_name}`
                     WHERE qloud_project = 'tools-access'
                       AND qloud_application = 'idm'
                       AND qloud_environment = '{qloud_environment}'
                       AND $path_match(request)
                       AND $capture(request) is NOT NULL
                     UNION ALL
                    -- details
                    SELECT COALESCE($details_capture(request) || "<id>", "") as request_path,
                           IF(status < "300", CAST(nginx_request_time as Double))  as execution_time,
                           COALESCE(nginx_request_method, "") as http_method,
                           status
                      FROM `{log_path}{table_name}`
                     WHERE qloud_project = 'tools-access'
                       AND qloud_application = 'idm'
                       AND qloud_environment = '{qloud_environment}'
                       AND $details_path_match(request)
               )
           GROUP BY http_method, request_path;
    """

    def get_yql_query(self, log_type, table_name):
        qloud_environment = yenv.type

        full_query = self.YQL_QUERY.format(
            table_name=table_name,
            qloud_environment=qloud_environment,
            stat_cluster=self.STAT_CLUSTERS[qloud_environment],
            report_path=self.REPORT_PATH[log_type],
            log_path=self.LOG_PATH[log_type],
            period_length=self.PERIOD_LENGTH[log_type],
        )
        return full_query
