from idm.metrics.management.commands.base import StatfaceBaseCommand


class Command(StatfaceBaseCommand):

    TASK_NAME = 'ErrorDistributionCounter'
    report = StatfaceBaseCommand.client.get_report('ExtData/idm/api/errors_distribution')
    select_fields = [
        'request',
        'fielddate',
        'sum(case when bad_response_flag = 1 then 1 else 0 end) as bad_responses'
    ]

    def get_initial_values(self):
        initial_data = {url: 0 for url in self.api_v1_urls}
        return initial_data

    def populate_data(self, data, request):
        for raw_dict in super(Command, self).populate_data(data, request):
            data[raw_dict['fielddate']][raw_dict['request'].lower()] = raw_dict['bad_responses']

    def get_final_result(self, data):
        result = []
        for fielddate, row in data.items():
            final_row = {
                'fielddate': fielddate
            }
            final_row.update(row)
            result.append(final_row)

        return result
