from idm.metrics.management.commands.base import StatfaceBaseCommand


class Command(StatfaceBaseCommand):

    TASK_NAME = 'ErrorsByMethodsCounter'
    report = StatfaceBaseCommand.client.get_report('ExtData/idm/api/errors_by_method')
    select_fields = [
        'request',
        'fielddate',
        'request_method',
        'sum(case when bad_response_flag = 1 then 1 else 0 end) as bad_responses'
    ]
    subselect_fields = StatfaceBaseCommand.subselect_fields + ['nginx_request_method as request_method']
    group_by_fields = StatfaceBaseCommand.group_by_fields + ['request_method']

    def get_initial_values(self):
        initial_counter = {
            'get': 0,
            'post': 0,
            'put': 0,
            'delete': 0,
            'update': 0
        }

        initial_data = {url: initial_counter.copy() for url in self.api_v1_urls}
        return initial_data

    def populate_data(self, data, request):
        for raw_dict in super(Command, self).populate_data(data, request):
            data[raw_dict['fielddate']][raw_dict['request']][raw_dict['request_method'].lower()] = raw_dict['bad_responses']

    def get_final_result(self, data):
        result = []
        for fielddate, request_data in data.items():
            for request, dct in request_data.items():
                final_row = {
                    'request': request,
                    'fielddate': fielddate
                }

                for method, bad_responses in dct.items():
                    final_row[method] = bad_responses

                result.append(final_row)

        return result
