from idm.metrics.management.commands.base import StatfaceBaseCommand


class Command(StatfaceBaseCommand):

    TASK_NAME = 'GoodAndBadRequestCounter'
    report = StatfaceBaseCommand.client.get_report('ExtData/idm/api/v1')
    select_fields = [
        'request',
        'fielddate',
        'sum(case when bad_response_flag = 0 then 1 else 0 end) as good_responses',
        'sum(case when bad_response_flag = 1 then 1 else 0 end) as bad_responses'
    ]

    def get_initial_values(self):
        initial_values = {url: (0, 0) for url in self.api_v1_urls}
        return initial_values

    def populate_data(self, data, request):
        for raw_dict in super(Command, self).populate_data(data, request):
            data[raw_dict['fielddate']][raw_dict['request']] = (raw_dict['good_responses'], raw_dict['bad_responses'])

    def get_final_result(self, data):
        result = []
        for fielddate, request_details in data.items():
            for request, numbers in request_details.items():
                final_row = {
                    'fielddate': fielddate,
                    'request': request,
                    'good_responses': numbers[0],
                    'bad_responses': numbers[1]
                }
                result.append(final_row)

        return result
