import yenv

from idm.metrics.management.base_api_response_percentile import MetricBaseCommand, MINUTE_LOG, DAY_LOG
from idm.core.constants.inconsistency_audit import INCONSISTENCY_AUDIT_STEPS


class Command(MetricBaseCommand):
    help = """Считает и загружает в статфейс статистику по времени запуска шагов сверки ролей"""

    SYNTAX_VERSION = 1

    LOG_TYPES = (DAY_LOG,)

    LOG_PATH = {
        DAY_LOG: 'home/logfeller/logs/qloud-runtime-log/1d/',
    }

    REPORT_PATH = {
        DAY_LOG: 'ExtData/idm/inconsistencies_audit_time/daily'
    }

    YQL_QUERY = r"""
        -- idm_inconsistencies_audit_time
        USE hahn;
        PRAGMA yson.DisableStrict;
        
        $audit_step_finished = ($fields) -> {{ return Yson::ConvertToBool($fields.context.audit_step_finished); }};
        $source = ($fields) -> {{ return Yson::ConvertToString($fields.context.source); }};
        $step = ($fields) -> {{ return Yson::ConvertToString($fields.context.step); }};
        $system = ($fields) -> {{ return Yson::ConvertToString($fields.context.system); }};
        $total_time = ($fields) -> {{ return Yson::ConvertToDouble($fields.context.total_time); }};
        $unique_id = ($fields) -> {{ return Yson::ConvertToInt64($fields.context.unique_id); }};

        $records = (
        SELECT COALESCE($step(fields), "") as step, 
               COALESCE($system(fields), "") as system,
               $total_time(fields) as total_time,
               $unique_id(fields) as unique_id
          FROM `{log_path}{table_name}`
         WHERE 
               qloud_project = 'tools-access'
           AND qloud_application = 'idm'
           AND qloud_environment = '{qloud_environment}'
           AND $audit_step_finished(fields) = true
           AND $source(fields) = "audit_memory"
           AND $unique_id(fields) is not null
        );

        $aggregated_records = (
        SELECT system, total_time, unique_id
          FROM (
                SELECT system, sum(total_time) as total_time, count(*) as n_steps, unique_id
                  FROM $records
                 GROUP BY system, unique_id
          )
         WHERE n_steps = {steps_count}
        );

        UPSERT INTO {stat_cluster}.`{report_path}`
            SELECT '{table_name}' as fielddate, step, system, max(total_time) as total_time
              FROM $records
          GROUP BY step, system
             UNION ALL
            SELECT '{table_name}' as fielddate, "all_steps" as step, system, max(total_time) as total_time
              FROM $aggregated_records
          GROUP BY system
        ;
    """


    def get_yql_query(self, log_type, table_name):
        qloud_environment = yenv.type

        full_query = self.YQL_QUERY.format(
            table_name=table_name,
            qloud_environment=qloud_environment,
            stat_cluster=self.STAT_CLUSTERS[qloud_environment],
            report_path=self.REPORT_PATH[log_type],
            log_path=self.LOG_PATH[log_type],
            steps_count=len(INCONSISTENCY_AUDIT_STEPS.ALL_STEPS),
        )
        return full_query
