import yenv

from idm.metrics.management.base_api_response_percentile import MetricBaseCommand, MINUTE_LOG, DAY_LOG


class Command(MetricBaseCommand):
    help = """Считает и загружает в статфейс статистику по времени выполнения workflow"""

    LOG_PATH = {
        MINUTE_LOG: 'home/logfeller/logs/qloud-runtime-log/stream/5min/',
        DAY_LOG: 'home/logfeller/logs/qloud-runtime-log/1d/',
    }

    REPORT_PATH = {
        DAY_LOG: 'ExtData/idm/api/workflow_execution_time/daily',
    }

    YQL_QUERY = r"""
        -- idm_workflow_execution
        USE hahn;
        PRAGMA yson.DisableStrict;
        PRAGMA AnsiInForEmptyOrNullableItemsCollections;

        UPSERT INTO {stat_cluster}.`{report_path}`
            SELECT  '{table_name}' as fielddate,
                    Math::Round(PERCENTILE(container_creation, 0.75), -1) as creation_75,
                    Math::Round(PERCENTILE(container_creation, 0.90), -1) as creation_90,
                    Math::Round(PERCENTILE(container_creation, 0.99), -1) as creation_99,
                    Math::Round(PERCENTILE(container_destruction, 0.75), -1) as destruction_75,
                    Math::Round(PERCENTILE(container_destruction, 0.90), -1) as destruction_90,
                    Math::Round(PERCENTILE(container_destruction, 0.99), -1) as destruction_99,
                    Math::Round(PERCENTILE(workflow_execution, 0.75), -1) as execution_75,
                    Math::Round(PERCENTILE(workflow_execution, 0.90), -1) as execution_90,
                    Math::Round(PERCENTILE(workflow_execution, 0.99), -1) as execution_99,
                    Math::Round(PERCENTILE(total, 0.75), -1) as total_75,
                    Math::Round(PERCENTILE(total, 0.90), -1) as total_90,
                    Math::Round(PERCENTILE(total, 0.99), -1) as total_99,
                    COUNT(*) as runs_count
               FROM (
                    SELECT
                        Yson::ConvertToDouble(fields.context.container_creation_time) as container_creation,
                        Yson::ConvertToDouble(fields.context.container_destruction_time) as container_destruction,
                        (
                            Yson::ConvertToDouble(fields.context.execution_time)
                            - Yson::ConvertToDouble(fields.context.container_creation_time)
                            - Yson::ConvertToDouble(fields.context.container_destruction_time)
                        ) as workflow_execution,
                        Yson::ConvertToDouble(fields.context.execution_time) as total
                    FROM `{log_path}{table_name}`
                    WHERE
                           qloud_project = 'tools-access'
                       AND qloud_application = 'idm'
                       AND qloud_environment = '{qloud_environment}'
                       AND Yson::ConvertToString(fields.context.profiling.block_type) = 'sandboxed_workflow'
                       AND Yson::ConvertToString(fields.context.reason) IN ({reasons})
               );
        """

    WORKFLOW_REASONS = ['simulate', 'request']

    def get_yql_query(self, log_type, table_name):
        qloud_environment = yenv.type

        full_query = self.YQL_QUERY.format(
            table_name=table_name,
            qloud_environment=qloud_environment,
            stat_cluster=self.STAT_CLUSTERS[qloud_environment],
            report_path=self.REPORT_PATH[log_type],
            log_path=self.LOG_PATH[log_type],
            reasons=', '.join(["'{}'".format(reason) for reason in self.WORKFLOW_REASONS]),
        )
        return full_query
