# coding: utf-8



from django.utils import timezone
import constance
from metrics_framework.decorators import metric

from idm.core.models import Action
from idm.core.constants.action import ACTION


@metric('successful_nodes_syncs')
def count_successful_nodes_syncs():
    result = []
    for system_slug in constance.config.SYSTEM_SLUGS_FOR_MONITORING.split(','):
        actions = Action.objects.filter(
            system__slug=system_slug,
            added__gte=timezone.now() - timezone.timedelta(weeks=1)
        )
        started_sync_actions = actions.filter(action=ACTION.ROLE_TREE_STARTED_SYNC)
        synced_actions = actions.filter(action=ACTION.ROLE_TREE_SYNCED)
        successfully_synced_actions = [action for action in synced_actions if action.data['status'] == 0]
        result.append({
            'slug': system_slug + '_success',
            'value': len(successfully_synced_actions),
        })
        result.append({
            'slug': system_slug + '_fail',
            'value': started_sync_actions.count() - len(successfully_synced_actions),
        })
    return result


@metric('successful_nodes_syncs_time')
def count_successful_nodes_syncs_time():
    result = []
    for system_slug in constance.config.SYSTEM_SLUGS_FOR_MONITORING.split(','):
        synced_actions = Action.objects.filter(
            system__slug=system_slug,
            action=ACTION.ROLE_TREE_SYNCED,
            added__gte=timezone.now() - timezone.timedelta(weeks=1)
        ).select_related('parent')
        sync_times = [
            action.added - action.parent.added
            for action in synced_actions
            if action.data['status'] == 0
        ]
        sync_times.sort()
        result.append({
            'slug': system_slug,
            'value': sync_times[int(len(sync_times)*0.9 - 1)].total_seconds()
                     if sync_times else 0,
        })
    return result
