# coding: utf-8



from collections import defaultdict

from django.db.models import Q
from django.utils import timezone
from metrics_framework.decorators import metric

from idm.core.models import RoleNode


def get_nodes_to_process(base_field, fields, now):
    # получим все узлы, которые стали ок за последний час или еще не стали ок
    q = Q()
    for field in fields:
        q |= Q(**{field: None}) | Q(**{'%s__gte' % field: now - timezone.timedelta(hours=1)})

    return RoleNode.objects.filter(q, **{'%s__isnull' % base_field: False})


@metric('slug_paths')
def get_slug_paths_states():
    percentiles = [90, 95, 99, 100]
    now = timezone.now()
    fields_mapping = {
        'moved_at': ['slug_path_ok_after_move_at', 'suggest_ok_after_move_at'],
        'pushed_at': ['slug_path_ok_after_push_at', 'suggest_ok_after_push_at'],
    }
    field_to_timedeltas = defaultdict(list)

    for base_field, fields in fields_mapping.items():
        nodes = get_nodes_to_process(base_field, fields, now)
        for node in nodes:
            for field in fields:
                field_to_timedeltas[field].append(
                    (getattr(node, field) or now) - getattr(node, base_field)
                )

    result = []
    for field, timedeltas in field_to_timedeltas.items():
        timedeltas = sorted(timedeltas)
        for percentile in percentiles:
            index = int(len(timedeltas) * (percentile / 100)) - 1
            result.append(
                {
                    'slug': ('%s_%s' % (field, percentile)).replace('_at', ''),
                    'value': timedeltas[index].total_seconds() if timedeltas else 0
                }
            )

    return result
