# coding: utf-8

from django.http import HttpResponse, HttpResponseBadRequest


class MonitoringAnswer(object):
    status_code = None

    def __init__(self, messages):
        self.messages = messages


class NoErrorAnswer(MonitoringAnswer):
    status_code = HttpResponse().status_code


class WarnAnswer(MonitoringAnswer):
    status_code = 412


class CritAnswer(MonitoringAnswer):
    status_code = HttpResponseBadRequest().status_code
