import logging
from typing import Union

from attr import dataclass, attrib
from django.core.cache import cache

log = logging.getLogger(__name__)

TMetricValue = Union[str, int, float]

DEFAULT_AGGREGATION = 'max'
DEFAULT_TTL = 60 * 60


@dataclass
class CachedMetric:
    key: str
    ttl: int = attrib(default=DEFAULT_TTL, repr=False)

    def set(self, value):
        cache.set(self.key, value, self.ttl)

    def get(self):
        return cache.get(self.key)


ActiveRolesOfInactiveGroupsMetric = CachedMetric('active_roles_of_inactive_groups', 2 * 24 * 60 * 60)
FiredUsersLimitExceededMetric = CachedMetric('fired_users_limit_exceeded', 60 * 60)
OverlengthedRefRoleChainMetric = CachedMetric('overlengthed_ref_roles_chain',  2 * 24 * 60 * 60)
PassportLoginsToSubscribeMetric = CachedMetric('unistat_logins_to_subscribe', 60 * 60)
ReviewRolesThresholdExceededMetric = CachedMetric('review_roles_exceeded_threshold', 24 * 60 * 60)
UnsubscribedLoginsMetric = CachedMetric('unsubscribed_logins', 3 * 60 * 60)
QueueSizeMetric = CachedMetric('queue_size', 30)
PeriodicTimestampsMetric = CachedMetric('execution_timestamps', 30)
RoleStatesMetric = CachedMetric('role_states', 30)
InconsistencyStatesMetric = CachedMetric('inconsistency_states', 60 * 60)
LastSyncStatesMetric = CachedMetric('last_sync_states', 60 * 60)
GroupMembershipStatesMetric = CachedMetric('group_membership_system_states', 30)
FailedDeprivingRolesMetric = CachedMetric('failed_depriving_roles', 3 * 60 * 60)
TotalDeprivingRolesMetric = CachedMetric('total_depriving_roles', 3 * 60 * 60)
