# coding: utf-8


from django.conf.urls import url

from idm.monitorings.views.active_roles_of_inactive_groups import ActiveRolesOfInactiveGroups
from idm.monitorings.views.closure_inconsistencies import ClosureInconsistenciesCountView, ClosureInconsistentPathsView
from idm.monitorings.views.fired_users_limit_exceeded import NotBlockedFiredUsersCount
from idm.monitorings.views.gap_synchronization import GapSynchronizationErrorsView
from idm.monitorings.views.groups_closure_inconsistencies import GroupsClosureInconsistentCountView
from idm.monitorings.views.hanging_roles import HangingApprovedRolesView, HangingDeprivingRolesView
from idm.monitorings.views.logins_to_subscribe import PassportLoginsToSubscribe
from idm.monitorings.views.not_blocked_ad_users import AdBlockedUsersView
from idm.monitorings.views.not_pushed_system_roles import SystemRolePushView
from idm.monitorings.views.overlengthed_ref_roles_chain import OverlengthedRefRolesChain
from idm.monitorings.views.review_roles_threshold_exceeded import ReviewRolesThresholdExceeded
from idm.monitorings.views.unistat import UnistatView
from idm.monitorings.views.unsubscribed_logins import UnsubscribedLoginsView
from idm.monitorings.views.unsynchronized_systems import UnsynchronizedSystemsView
from idm.monitorings.views.users_without_department_group import UsersWithoutDepartmentGroupView
from idm.monitorings.views.idm_error_count import IdmErrorCount
from idm.monitorings.views.failed_review_roles import FailedReviewRolesView

urlpatterns = [
    url(r'^active-roles-of-inactive-groups/$', ActiveRolesOfInactiveGroups.as_view(),
        name='active-roles-of-inactive-groups'),
    url(r'^closure-inconsistencies-count/$', ClosureInconsistenciesCountView.as_view(),
        name='closure-inconsistencies-count'),
    url(r'^closure-inconsistent-paths/$', ClosureInconsistentPathsView.as_view(), name='closure-inconsistent-paths'),
    url(r'^hanging-approved-roles/$', HangingApprovedRolesView.as_view(), name='hanging-approved-roles'),
    url(r'^hanging-depriving-roles/$', HangingDeprivingRolesView.as_view(), name='hanging-depriving-roles'),
    url(r'^logins-to-subscribe/$', PassportLoginsToSubscribe.as_view(), name='logins-to-subscribe'),
    url(r'^gap-synchronization-errors/$', GapSynchronizationErrorsView.as_view(), name='gap-synchronization-errors'),
    url(
        r'^groups-closure-inconsistent-count/$',
        GroupsClosureInconsistentCountView.as_view(),
        name='groups-closure-inconsistent-count'
    ),
    url(r'^unsynchronized-systems/$', UnsynchronizedSystemsView.as_view(), name='unsynchronized-systems'),
    url(
        r'^users-without-department-group/$',
        UsersWithoutDepartmentGroupView.as_view(),
        name='users-without-department-group'
    ),
    url(
        r'^not-pushed-system-roles/$',
        SystemRolePushView.as_view(),
        name='not-pushed-system-roles'
    ),
    url(
        r'^not-blocked-limit/$',
        NotBlockedFiredUsersCount.as_view(),
        name='not-blocked-limit',
    ),
    url(r'^unistat/$', UnistatView.as_view(), name='unistat'),
    url(
        r'^not-blocked-ad-users/$',
        AdBlockedUsersView.as_view(),
        name='not-blocked-ad-users'
    ),
    url(r'^overlengthed-ref-roles/$', OverlengthedRefRolesChain.as_view(), name='overlengthed-ref-roles'),
    url(
        r'^unsubscribed-logins/$',
        UnsubscribedLoginsView.as_view(),
        name='unsubscribed-logins'
    ),
    url(
        r'^review-roles-exceeded/$',
        ReviewRolesThresholdExceeded.as_view(),
        name='review-roles-exceeded',
    ),
    url(
        r'^idm-error-count/$',
        IdmErrorCount.as_view(),
        name='idm-error-count',
    ),
    url(
        r'^failed-review-roles/$',
        FailedReviewRolesView.as_view(),
        name='failed-review-roles',
    ),
]
