from django.conf import settings

from idm.monitorings.metric import ActiveRolesOfInactiveGroupsMetric
from idm.monitorings.views.base import BaseCachedMonitoring


class ActiveRolesOfInactiveGroups(BaseCachedMonitoring):
    cached_metric = ActiveRolesOfInactiveGroupsMetric

    def get_errors_from_cached_value(self, cached_value):
        for key, value in cached_value.items():
            if not value:
                continue
            if 'onhold' in key:
                continue
            if (
                    key == 'personal_by_ref_amount' 
                    and value < settings.IDM_PERSONAL_BY_REF_AMOUNT_THRESHOLD
            ):
                continue

            return [
                'Active roles of inactive groups:\n' + '\n'.join(
                (f'{k}: {v}' for k, v in cached_value.items()))
            ]

        return []
