# coding: utf-8


from datetime import timedelta

from idm.monitorings.views.base import BaseMetricMonitoringView


class ClosureInconsistenciesCountView(BaseMetricMonitoringView):
    @property
    def metric_slug(self):
        return 'closure_inconsistencies_count'

    def is_bad_value(self, value):
        return value > 0


class ClosureInconsistentPathsView(BaseMetricMonitoringView):
    @property
    def metric_slug(self):
        return 'closure_inconsistent_paths'

    def is_bad_value(self, value):
        return value > 0
