# coding: utf-8

from idm.core.models import SystemMetainfo
from idm.monitorings.views.base import BaseMonitoringView
from idm.monitorings.answer import WarnAnswer


class FailedReviewRolesView(BaseMonitoringView):
    COUNT_THRESHOLD = 0

    def error_messages(self, count):
        return ['IDM has {} failed roles on last review'.format(count)]

    def get_queryset(self):
        return SystemMetainfo.objects.filter(
            roles_failed_on_last_review__isnull=False
        ).values('roles_failed_on_last_review')

    def monitoring(self):
        count = 0
        for system_meta_info_with_failed_role in self.get_queryset():
            count += len(system_meta_info_with_failed_role['roles_failed_on_last_review'])

        if count > self.COUNT_THRESHOLD:
            return WarnAnswer(self.error_messages(count))

        return []
