from idm.monitorings.metric import FiredUsersLimitExceededMetric
from idm.monitorings.views.base import BaseCachedMonitoring


class NotBlockedFiredUsersCount(BaseCachedMonitoring):
    cached_metric = FiredUsersLimitExceededMetric

    def get_errors_from_cached_value(self, cached_value):
        errors = []
        if cached_value:
            errors.append(f'Not blocked fired users count: {cached_value}')

        return errors
